<?php
// save-pending.php – guarda qso-pending.json en el raíz y almacena 'code' (visible)
header('Content-Type: application/json; charset=utf-8');

$REQUIRED_CODE = getenv('QSO_WRITE_CODE') ?: '';

$raw = file_get_contents('php://input');
$data = json_decode($raw, true);
if (!$data && !empty($_POST)) { $data = $_POST; }

$hdrCode = isset($_SERVER['HTTP_X_QSO_CODE']) ? $_SERVER['HTTP_X_QSO_CODE'] : '';
$bodyCode = isset($data['code']) ? strval($data['code']) : '';
$provided = $hdrCode ?: $bodyCode;

if ($REQUIRED_CODE !== '' && $provided !== $REQUIRED_CODE) {
  http_response_code(403);
  echo json_encode(['ok'=>false, 'error'=>'forbidden']);
  exit;
}

$set = isset($data['set']) && is_array($data['set']) ? $data['set'] : [];
$freq = isset($set['freqHz']) ? intval($set['freqHz']) : null;
$mode = isset($set['mode']) ? strtoupper(strval($set['mode'])) : null;

$out = [
  'pending' => true,
  'label' => 'QSO Pending',
  'set' => [],
  'code' => strval($provided), // <-- se guarda el código tal cual (visible)
  'timestamp' => round(microtime(true)*1000)
];
if ($freq !== null) $out['set']['freqHz'] = $freq;
if ($mode) $out['set']['mode'] = $mode;

$target = __DIR__ . DIRECTORY_SEPARATOR . 'qso-pending.json';
$tmp = $target . '.tmp';
if (file_put_contents($tmp, json_encode($out, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE)) === false) {
  http_response_code(500);
  echo json_encode(['ok'=>false, 'error'=>'write_tmp_failed']);
  exit;
}
if (!rename($tmp, $target)) {
  http_response_code(500);
  echo json_encode(['ok'=>false, 'error'=>'rename_failed']);
  exit;
}

echo json_encode(['ok'=>true]);
?>